package w83b.w83bOperacionesPaso.w83bResultados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaResultadosSexoExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoResultadosPorSexo.xls";
		InputStream inputStream = W83bTablaResultadosSexoExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        ArrayList resultados = (ArrayList)contexto.get("w83bListadoResultadosBean");
        W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");                    
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                    

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                    
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                          
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                    
        HashMap mapaResSexo=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);    
        
        HSSFCell cell2;
        
        HSSFRow row = sheet.getRow((short)4);                    
        HSSFCell cell = row.getCell((short)4);                    
        sheet.addMergedRegion(new Region(4,Short.parseShort("4"),4,Short.parseShort("5")));//NOPMD
        StringBuffer tituloImagenEs = (StringBuffer)mapaResSexo.get("tituloDepEs");                    
        StringBuffer tituloImagenEu =  (StringBuffer)mapaResSexo.get("tituloDepEu");                    
        cell.setCellValue(tituloImagenEu.toString());                    
        
        cell = row.getCell((short)7);   
        sheet.addMergedRegion(new Region(4,Short.parseShort("7"),4,Short.parseShort("8")));//NOPMD
        cell.setCellValue(tituloImagenEs.toString());                    
        
        tituloImagenEs = (StringBuffer)mapaResSexo.get("tituloDelelegacionEs");                    
        tituloImagenEu = (StringBuffer)mapaResSexo.get("tituloDelelegacionEu");                    
        
        
        row = sheet.getRow((short)6);                    
        cell = row.getCell((short)4);    
        sheet.addMergedRegion(new Region(4,Short.parseShort("4"),4,Short.parseShort("5")));//NOPMD
        cell.setCellValue(tituloImagenEu.toString());                    
        
        cell = row.getCell((short)7);                    
        sheet.addMergedRegion(new Region(8,Short.parseShort("7"),8,Short.parseShort("8")));//NOPMD
        cell.setCellValue(tituloImagenEs.toString());                    
        
        
        row = sheet.getRow((short)9);                    
        cell = row.getCell((short)0);                    
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.resultadosSexo").toUpperCase());                    
        
        row = sheet.getRow((short)10); 
        cell = row.getCell((short)4); 
       
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
    	}	
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)W83bClsConstantes.DOCE);
        cell = row.getCell((short)2);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.territorio"));
        cell = row.getCell((short)4); 
        sheet.addMergedRegion(new Region(12,Short.parseShort("4"),12,Short.parseShort("5")));//NOPMD
        W83bClsTrazas.trazaDebug(null, "territorio1: " + resultadoBean.getDescTerritorio());
       
        if(StringUtils.isNotEmpty(resultadoBean.getDescTerritorio()))
		{
			cell.setCellValue(resultadoBean.getDescTerritorio().toUpperCase());
		}else{
			 W83bClsTrazas.trazaDebug(null, "territorio2: " + Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.comautvascaentero",idioma).toUpperCase());
		       
			 cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.comautvascaentero",idioma).toUpperCase()));
		}
        
        
        
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.datosMinisterio.fechaEleccionDesde"));
        cell = row.getCell((short)10); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
        	cell.setCellValue(resultadoBean.getFechaEleccionDesde());
        }
        
        
        row = sheet.getRow((short)W83bClsConstantes.TRECE);
        cell = row.getCell((short)2);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.datosMinisterio.fechaResultado"));
        cell = row.getCell((short)4);
        sheet.addMergedRegion(new Region(13,Short.parseShort("4"),13,Short.parseShort("5")));//NOPMD
        if(StringUtils.isNotEmpty(resultadoBean.getFechaResultadoDesde())){
        	cell.setCellValue(resultadoBean.getFechaResultadoDesde());
        }
        
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.datosMinisterio.fechaEleccionHasta"));
        cell = row.getCell((short)10); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaResultadoDesde())){
        	cell.setCellValue(resultadoBean.getFechaResultadoDesde());
        }
        
        row = sheet.getRow((short)W83bClsConstantes.CATORCE);
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.datosMinisterio.fechaRegDefinitivo"));
        cell = row.getCell((short)10); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaRegistroDefinitivo())){
        	cell.setCellValue(resultadoBean.getFechaRegistroDefinitivo());
        }
        
        row = sheet.getRow((short)W83bClsConstantes.DIECISIETE);
        cell = row.getCell((short)2);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.electores"));
        
        cell = row.getCell((short)5);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.candidatos"));
        
        cell = row.getCell((short)10);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.menu.Delegados"));
        
        row = sheet.getRow((short)W83bClsConstantes.DIECIOCHO);
        cell = row.getCell((short)0);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.territorio"));
        cell = row.getCell((short)2);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.hombres"));
        cell = row.getCell((short)3);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.mujeres"));
        cell = row.getCell((short)4);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.totales"));
        cell = row.getCell((short)5);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.hombres"));
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.mujeres"));
        cell = row.getCell((short)8);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.totales"));
        cell = row.getCell((short)10);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.hombres"));
        cell = row.getCell((short)11);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.mujeres"));
        cell = row.getCell((short)12);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.totales"));
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        
        Iterator itResul = resultados.iterator();
        int eleH = 0;
        int eleM = 0;
        int ele = 0;
        int candH = 0;
        int candM = 0;
        int repreH = 0;
        int repreM = 0;
        int repre = 0;
        int eleTotalH=0;
        int eleTotalM=0;
        int eleTotal=0;
        int candTotalH=0;
        int candTotalM=0;
        int repreTotalH=0;
        int repreTotalM=0;
        int repreTotal=0;
        W83bResultadosBean current = null;
        int cont= 0;
        int contadorTerritorios= 0;
        int fila= 0;
        String territorioInicio="" ;
        while(itResul.hasNext()){
        	
        	current = (W83bResultadosBean) itResul.next();
        	if(cont==0){
        		territorioInicio= current.getProvincia();
        		//valores nuevos
        		eleH = Integer.parseInt(current.getElectoresH());
            	eleM = Integer.parseInt(current.getElectoresM());
            	ele = Integer.parseInt(current.getTotalelectores());
                candH = Integer.parseInt(current.getCandidatosH());
                candM = Integer.parseInt(current.getCandidatosM());
                repreH = Integer.parseInt(current.getNumdelegadosH());
                repreM = Integer.parseInt(current.getNumdelegadosM());
                repre = Integer.parseInt(current.getNumdelegados());
        		
        	}
        	else if(!territorioInicio.equals(current.getProvincia())){
        		//cambiamos de territorio
        		//rellenamos
        		fila=W83bClsConstantes.DIEZYNUEVE+contadorTerritorios;
        		row = sheet.getRow((short)fila);
                cell = row.getCell((short)0);
                sheet.addMergedRegion(new Region(fila,Short.parseShort("0"),fila,Short.parseShort("1")));//NOPMD
                if(StringUtils.isNotEmpty(territorioInicio)){
                	cell.setCellValue(territorioInicio.toUpperCase());
                }
                cell.setCellStyle(estiloFilaNumeroCentrado(fila,excel));
                cell = row.createCell((short)1);
                cell.setCellStyle(estiloFilaNumeroCentrado(fila,excel));
                
                cell2 = row.createCell((short)2);
                cell2.setCellValue(eleH);
                cell2.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
                
                cell = row.createCell((short)3);
                cell.setCellValue(eleM);
                cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
                
                cell2 = row.createCell((short)4);
                cell2.setCellValue(ele);
                cell2.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
                
                cell = row.createCell((short)5);
                sheet.addMergedRegion(new Region(fila,Short.parseShort("5"),fila,Short.parseShort("6")));//NOPMD
                cell.setCellValue(candH);
                cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
                cell2 = row.createCell((short)6);
                cell2.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
                
                 
                cell = row.createCell((short)7);
                sheet.addMergedRegion(new Region(fila,Short.parseShort("8"),fila,Short.parseShort("9")));//NOPMD
                cell.setCellValue(candM);
                cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
                
                cell2 = row.createCell((short)8);
                sheet.addMergedRegion(new Region(fila,Short.parseShort("8"),fila,Short.parseShort("9")));//NOPMD
                cell2.setCellValue(candH + candM);
                cell2.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
                cell = row.createCell((short)9);
                cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
                
                
                cell2 = row.createCell((short)10);
                cell2.setCellValue(repreH);
                cell2.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
                
                cell = row.createCell((short)11);
                cell.setCellValue(repreM);
                cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
                
                cell2 = row.createCell((short)12);
                cell2.setCellValue(repre);
                cell2.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        		//inicializamos con los valores nuevos
                contadorTerritorios++;
                territorioInicio= current.getProvincia();
        		eleH = Integer.parseInt(current.getElectoresH());
            	eleM = Integer.parseInt(current.getElectoresM());
            	ele = Integer.parseInt(current.getTotalelectores());
                candH = Integer.parseInt(current.getCandidatosH());
                candM = Integer.parseInt(current.getCandidatosM());
                repreH = Integer.parseInt(current.getNumdelegadosH());
                repreM = Integer.parseInt(current.getNumdelegadosM());
                repre = Integer.parseInt(current.getNumdelegados());
        	}
        	else {
        		//mismo territorio
        		//sumamos
        		eleH = eleH +Integer.parseInt(current.getElectoresH());
            	eleM = eleM +Integer.parseInt(current.getElectoresM());
            	ele = ele + Integer.parseInt(current.getTotalelectores());
                candH = candH +Integer.parseInt(current.getCandidatosH());
                candM = candM +Integer.parseInt(current.getCandidatosM());
                repreH = repreH +Integer.parseInt(current.getNumdelegadosH());
                repreM = repreM +Integer.parseInt(current.getNumdelegadosM());
                repre = repre + Integer.parseInt(current.getNumdelegados());
        	}
        	eleTotalH=eleTotalH+Integer.parseInt(current.getElectoresH());
        	eleTotalM=eleTotalM+Integer.parseInt(current.getElectoresM());
        	eleTotal = eleTotal + Integer.parseInt(current.getTotalelectores());
        	candTotalH = candTotalH +Integer.parseInt(current.getCandidatosH());
            candTotalM = candTotalM +Integer.parseInt(current.getCandidatosM());
            repreTotalH = repreTotalH +Integer.parseInt(current.getNumdelegadosH());
            repreTotalM = repreTotalM +Integer.parseInt(current.getNumdelegadosM());
            repreTotal = repreTotal + Integer.parseInt(current.getNumdelegados());
        	cont++;
        	
        }
        fila=W83bClsConstantes.DIEZYNUEVE+contadorTerritorios;
		row = sheet.getRow((short)fila);
        cell = row.getCell((short)0);
        sheet.addMergedRegion(new Region(fila,Short.parseShort("0"),fila,Short.parseShort("1")));//NOPMD
        if(StringUtils.isNotEmpty(territorioInicio)){
        	cell.setCellValue(territorioInicio.toUpperCase());
        }
        cell.setCellStyle(estiloFilaNumeroCentrado(fila,excel));
        cell = row.createCell((short)1);
        cell.setCellStyle(estiloFilaNumeroCentrado(fila,excel));
        
        cell = row.createCell((short)2);
        cell.setCellValue(eleH);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        
        cell = row.createCell((short)3);
        cell.setCellValue(eleM);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        
        cell = row.createCell((short)4);
        cell.setCellValue(ele);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        
        cell = row.createCell((short)5);
        sheet.addMergedRegion(new Region(fila,Short.parseShort("5"),fila,Short.parseShort("6")));//NOPMD
        cell.setCellValue(candH);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        cell = row.createCell((short)6);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        
         
        cell = row.createCell((short)7);
        sheet.addMergedRegion(new Region(fila,Short.parseShort("8"),fila,Short.parseShort("9")));//NOPMD
        cell.setCellValue(candM);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        
        cell = row.createCell((short)8);
        sheet.addMergedRegion(new Region(fila,Short.parseShort("8"),fila,Short.parseShort("9")));//NOPMD
        cell.setCellValue(candH + candM);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        cell = row.createCell((short)9);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        
        
        cell = row.createCell((short)10);
        cell.setCellValue(repreH);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        
        cell = row.createCell((short)11);
        cell.setCellValue(repreM);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        
        cell = row.createCell((short)12);
        cell.setCellValue(repre);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        
        //fila final de CAV
        if(StringUtils.isEmpty(resultadoBean.getTerritorio())){
        	fila=W83bClsConstantes.DIEZYNUEVE+contadorTerritorios+1;
    		row = sheet.getRow((short)fila);
            cell = row.getCell((short)0);
            sheet.addMergedRegion(new Region(fila,Short.parseShort("0"),fila,Short.parseShort("1")));//NOPMD
            cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.comautvascaentero",idioma).toUpperCase()));
            cell.setCellStyle(estiloFilaNumeroCentrado(fila,excel));
            cell = row.createCell((short)1);
            cell.setCellStyle(estiloFilaNumeroCentrado(fila,excel));
            
            cell = row.createCell((short)2);
            cell.setCellValue(eleTotalH);
            cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
            
            cell = row.createCell((short)3);
            cell.setCellValue(eleTotalM);
            cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
            
            cell = row.createCell((short)4);
            cell.setCellValue(eleTotal);
            cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
            
            cell = row.createCell((short)5);
            sheet.addMergedRegion(new Region(fila,Short.parseShort("5"),fila,Short.parseShort("6")));//NOPMD
            cell.setCellValue(candTotalH);
            cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
            cell = row.createCell((short)6);
            cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
            
             
            cell = row.createCell((short)7);
            sheet.addMergedRegion(new Region(fila,Short.parseShort("8"),fila,Short.parseShort("9")));//NOPMD
            cell.setCellValue(candTotalM);
            cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
            
            cell = row.createCell((short)8);
            sheet.addMergedRegion(new Region(fila,Short.parseShort("8"),fila,Short.parseShort("9")));//NOPMD
            cell.setCellValue(candTotalH + candTotalM);
            cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
            cell = row.createCell((short)9);
            cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
            
            
            cell = row.createCell((short)10);
            cell.setCellValue(repreTotalH);
            cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
            
            cell = row.createCell((short)11);
            cell.setCellValue(repreTotalM);
            cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
            
            cell = row.createCell((short)12);
            cell.setCellValue(repreTotal);
            cell.setCellStyle(estiloFilaNumeroCentradoFormateado(fila,excel));
        }
        //FIN FILA FINAL
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoResultadosPorSexo.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		return excel.styleTextoParNumeroCentrado;//NOPMD
	}
	
	/**
	 * Estilo fila numero centrado formateado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentradoFormateado(int nFila, W83bUtilidadesExcel excel){
		return excel.styleTextoParNumeroCentradoFormateado;//NOPMD
	}
}
